
//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//
//     TextTransform Samples/Packages/com.unity.collections/Unity.Collections.Tests/WordsTests.tt
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

#if !UNITY_DOTSPLAYER
using System;
using System.Globalization;
using System.Threading;
using NUnit.Framework;
using Unity.Collections;
using Unity.Collections.LowLevel.Unsafe;

namespace Collections.Tests
{

[TestFixture("en-US")]
[TestFixture("da-DK")]
internal class WordsTests
{
    CultureInfo testCulture;
    CultureInfo backupCulture;

    public WordsTests(string culture)
    {
        testCulture = CultureInfo.CreateSpecificCulture(culture);
    }

    [SetUp]
    public virtual void Setup()
    {
        backupCulture = Thread.CurrentThread.CurrentCulture;
        Thread.CurrentThread.CurrentCulture = testCulture;
//disable obsolete word/numberedwords collections
#pragma warning disable 0618
        WordStorage.Setup();
#pragma warning restore 0618
    }

    [TearDown]
    public virtual void TearDown()
    {
        Thread.CurrentThread.CurrentCulture = backupCulture;
    }

    unsafe void Wtf8(char[] truncated)
    {
        byte[] utf8 = new byte[truncated.Length * 4]; // temporary buffer, meant to hold UTF-8 copy of truncated string
        char[] output = new char[truncated.Length * 2]; // output of round trip of truncated data through UTF-8 back to UTF-16
        fixed(char *t = truncated)
        fixed(byte *u = utf8)
        fixed(char *o = output)
        {
            var error = Unicode.Utf16ToUtf8(t, truncated.Length, u, out int utf8_length, utf8.Length); // broken UTF-16 to UTF-8
            Assert.AreEqual(ConversionError.None, error);
            error = Unicode.Utf8ToUtf16(u, utf8_length, o, out int utf16_length, output.Length); // UTF-8 to broken UTF-16
            Assert.AreEqual(ConversionError.None, error);
            Assert.AreEqual(utf16_length, truncated.Length); // output should also be truncated by 16 bits,
            for (var i = 0; i < truncated.Length; ++i)
                Assert.AreEqual(truncated[i], output[i]); // and each 16 bits should match input, too.
        }
    }

    [TestCase("𝒞", TestName = "{m} C")]
    [TestCase("𝒯", TestName = "{m} T")]
    [TestCase("𝒮", TestName = "{m} S")]
    [TestCase("😁", TestName = "{m} GRINNING FACE WITH SMILING EYES")]
    [TestCase("😂", TestName = "{m} FACE WITH TEARS OF JOY")]
    [TestCase("😃", TestName = "{m} SMILING FACE WITH OPEN MOUTH")]
    public void Wtf8TruncatedString(string test)
    {
        char[] truncated = new char[2];

        truncated[0] = ' ';
        truncated[1] = test[0];
        Wtf8(truncated);

        truncated[0] = test[1];
        truncated[1] = ' ';
        Wtf8(truncated);
    }

    [TestCase("𝒞", TestName = "{m} C")]
    [TestCase("𝒯", TestName = "{m} T")]
    [TestCase("𝒮", TestName = "{m} S")]
    [TestCase("😁", TestName = "{m} GRINNING FACE WITH SMILING EYES")]
    [TestCase("😂", TestName = "{m} FACE WITH TEARS OF JOY")]
    [TestCase("😃", TestName = "{m} SMILING FACE WITH OPEN MOUTH")]
    public void Wtf8CorruptedString(string test)
    {
        char[] truncated = new char[3];

        truncated[0] = ' ';
        truncated[1] = test[0];
        truncated[2] = ' ';
        Wtf8(truncated);

        truncated[0] = ' ';
        truncated[1] = test[1];
        truncated[2] = ' ';
        Wtf8(truncated);
    }

    [Test]
    public unsafe void Utf8EncodeDecode([Range(0, 0xD7FF, 997)] int input_ucs)
    {
        var converted = new byte[4];
        fixed (byte* c = converted)
        {
            ConversionError error;
            int write_length = 0;
            error = Unicode.UcsToUtf8(c, ref write_length, converted.Length, new Unicode.Rune{value=input_ucs});
            Assert.AreEqual(ConversionError.None, error);
            int read_length = 0;
            error = Unicode.Utf8ToUcs(out var output_rune, c, ref read_length, write_length);
            Assert.AreEqual(ConversionError.None, error);
            Assert.AreEqual(write_length, read_length);
            Assert.AreEqual(output_rune.value, input_ucs);
        }
    }

    [Test]
    public unsafe void Utf16EncodeDecode([Range(0, 0xD7FF,997)] int input_ucs)
    {
        var converted = new char[2];
        fixed (char* c = converted)
        {
            ConversionError error;
            int write_length = 0;
            error = Unicode.UcsToUtf16(c, ref write_length, converted.Length, new Unicode.Rune{value = input_ucs});
            Assert.AreEqual(ConversionError.None, error);
            int read_length = 0;
            error = Unicode.Utf16ToUcs(out var output_rune, c, ref read_length, write_length);
            Assert.AreEqual(ConversionError.None, error);
            Assert.AreEqual(write_length, read_length);
            Assert.AreEqual(output_rune.value, input_ucs);
        }
    }

    unsafe void Utf16ToUtf8(string source)
    {
        var converted = new byte[source.Length * 4]; // UTF-8 text can be up to 2x as long as UTF-16 text
        var destination = new char[source.Length];
        fixed(byte* c = converted)
        fixed(char* s = source)
        fixed(char* d = destination)
        {
            Unicode.Utf16ToUtf8(s, source.Length, c, out var converted_length, converted.Length);
            Unicode.Utf8ToUtf16(c, converted_length, d, out var destination_length, destination.Length);
            Assert.AreEqual(source, destination);
        }
    }

    [TestCase("The Quick Brown Fox Jumps Over The Lazy Dog")]
    [TestCase("Albert osti fagotin ja töräytti puhkuvan melodian.", TestName = "{m}(Finnish)")]
    [TestCase("Franz jagt im komplett verwahrlosten Taxi quer durch Bayern.", TestName = "{m}(German)")]
    [TestCase("איך בלש תפס גמד רוצח עז קטנה?", TestName = "{m}(Hebrew)")]
    [TestCase("PORTEZ CE VIEUX WHISKY AU JUGE BLOND QUI FUME.", TestName = "{m}(French)")]
    [TestCase("いろはにほへとちりぬるをわかよたれそつねならむうゐのおくやまけふこえてあさきゆめみしゑひもせす", TestName = "{m}(Japanese)")]
    [TestCase("키스의 고유조건은 입술끼리 만나야 하고 특별한 기술은 필요치 않다.", TestName = "{m}(Korean)")]
    public unsafe void Utf16ToUtf8BMP(string source)
    {
        Utf16ToUtf8(source);
    }

    [TestCase("🌕🌖🌗🌘🌑🌒🌓🌔", TestName = "{m}(MoonPhases)")]
    [TestCase("𝒞𝒯𝒮𝒟𝒳𝒩𝒫𝒢", TestName = "{m}(Cursive)")]
    public unsafe void Utf16ToUtf8TransBMP(string source)
    {
        Utf16ToUtf8(source);
    }

//disable obsolete word/numberedwords collections
#pragma warning disable 0618
    [TestCase("red")]
    [TestCase("orange")]
    [TestCase("yellow")]
    [TestCase("green")]
    [TestCase("blue")]
    [TestCase("indigo")]
    [TestCase("violet")]
    [TestCase("紅色", TestName="{m}(Chinese-Red)")]
    [TestCase("橙色", TestName="{m}(Chinese-Orange)")]
    [TestCase("黄色", TestName="{m}(Chinese-Yellow)")]
    [TestCase("绿色", TestName="{m}(Chinese-Green)")]
    [TestCase("蓝色", TestName="{m}(Chinese-Blue")]
    [TestCase("靛蓝色", TestName="{m}(Chinese-Indigo")]
    [TestCase("紫罗兰色", TestName="{m}(Chinese-Violet")]
    [TestCase("црвена", TestName = "{m}(Serbian-Red)")]
    [TestCase("наранџаста", TestName = "{m}(Serbian-Orange)")]
    [TestCase("жута", TestName = "{m}(Serbian-Yellow)")]
    [TestCase("зелена", TestName = "{m}(Serbian-Green)")]
    [TestCase("плава", TestName = "{m}(Serbian-Blue")]
    [TestCase("индиго", TestName = "{m}(Serbian-Indigo")]
    [TestCase("љубичаста", TestName = "{m}(Serbian-Violet")]
    [TestCase("George Washington")]
    [TestCase("John Adams")]
    [TestCase("Thomas Jefferson")]
    [TestCase("James Madison")]
    [TestCase("James Monroe")]
    [TestCase("John Quincy Adams")]
    [TestCase("Andrew Jackson")]
    [TestCase("村上春樹", TestName="{m}(HarukiMurakami)")]
    [TestCase("三島 由紀夫", TestName="{m}(MishimaYukio)")]
    [TestCase("吉本ばなな", TestName="{m}(YoshimotoBanana)")]
    [TestCase("大江健三郎", TestName="{m}(OeKenzaburo)")]
    [TestCase("川端 康成", TestName="{m}(KawabataYasunari)")]
    [TestCase("桐野夏生", TestName="{m}(TongyeXiasheng)")]
    [TestCase("芥川龍之介", TestName="{m}(RyunosukeAkutagawa)")]
    [TestCase("로마는 하루아침에 이루어진 것이 아니다", TestName="{m}(Korean - Rome was not made overnight)")]
    [TestCase("낮말은 새가 듣고 밤말은 쥐가 듣는다", TestName="{m}(Korean-Proverb2)")]
    [TestCase("말을 냇가에 끌고 갈 수는 있어도 억지로 물을 먹일 수는 없다", TestName="{m}(Korean-Proverb3)")]
    [TestCase("호랑이에게 물려가도 정신만 차리면 산다", TestName="{m}(Korean-Proverb4)")]
    [TestCase("Љубазни фењерџија чађавог лица хоће да ми покаже штос.", TestName = "{m}(Serbian-Pangram)")]
    [TestCase("Лако ти је плитку воду замутити и будалу наљутити", TestName = "{m}(Serbian-Proverb)")]
    [TestCase("Үнэн үг хэлсэн хүнд ноёд өстэй, үхэр унасан хүнд ноход өстэй.", TestName="{m}(Mongolian-Proverb1)")]
    [TestCase("Өнгөрсөн борооны хойноос эсгий нөмрөх.", TestName="{m}(Mongolian-Proverb2)")]
    [TestCase("Барын сүүл байснаас батганы толгой байсан нь дээр.", TestName="{m}(Mongolian-Proverb3)")]
    [TestCase("Гараар ганц хүнийг дийлэх. Tолгойгоор мянган хүнийг дийлэх.", TestName="{m}(Mongolian-Proverb4)")]
    [TestCase("Աղւէսը բերանը խաղողին չի հասնում, ասում է՝ խակ է", TestName="{m}(Armenian-Proverb1)")]
    [TestCase("Ամեն փայտ շերեփ չի դառնա, ամեն սար՝ Մասիս", TestName="{m}(Armenian-Proverb2)")]
    [TestCase("Արևին ասում է դուրս մի արի՝ ես դուրս եմ եկել", TestName="{m}(Armenian-Proverb3)")]
    [TestCase("Գայլի գլխին Աւետարան են կարդում, ասում է՝ շուտ արէ՛ք, գալլէս գնաց", TestName="{m}(Armenian-Proverb4)")]
    [TestCase("पृथिव्यां त्रीणी रत्नानि जलमन्नं सुभाषितम्।", TestName="{m}(Hindi-Proverb1)")]
    [TestCase("जननी जन्मभुमिस्छ स्वर्गादपि गरीयसि", TestName="{m}(Hindi-Proverb2)")]
    [TestCase("न अभिशेको न संस्कारः सिम्हस्य कृयते वनेविक्रमार्जितसत्वस्य स्वयमेव मृगेन्द्रता", TestName="{m}(Hindi-Proverb3)")]
    public void WordsWorks(String value)
    {
        Words s = new Words();
        s.SetString(value);
        Assert.AreEqual(s.ToString(), value);
    }


    [TestCase("red")]
    [TestCase("orange")]
    [TestCase("yellow")]
    [TestCase("green")]
    [TestCase("blue")]
    [TestCase("indigo")]
    [TestCase("violet")]
    [TestCase("紅色", TestName="{m}(Chinese-Red)")]
    [TestCase("橙色", TestName="{m}(Chinese-Orange)")]
    [TestCase("黄色", TestName="{m}(Chinese-Yellow)")]
    [TestCase("绿色", TestName="{m}(Chinese-Green)")]
    [TestCase("蓝色", TestName="{m}(Chinese-Blue")]
    [TestCase("靛蓝色", TestName="{m}(Chinese-Indigo")]
    [TestCase("紫罗兰色", TestName="{m}(Chinese-Violet")]
    [TestCase("црвена", TestName = "{m}(Serbian-Red)")]
    [TestCase("наранџаста", TestName = "{m}(Serbian-Orange)")]
    [TestCase("жута", TestName = "{m}(Serbian-Yellow)")]
    [TestCase("зелена", TestName = "{m}(Serbian-Green)")]
    [TestCase("плава", TestName = "{m}(Serbian-Blue")]
    [TestCase("индиго", TestName = "{m}(Serbian-Indigo")]
    [TestCase("љубичаста", TestName = "{m}(Serbian-Violet")]
    [TestCase("George Washington")]
    [TestCase("John Adams")]
    [TestCase("Thomas Jefferson")]
    [TestCase("James Madison")]
    [TestCase("James Monroe")]
    [TestCase("John Quincy Adams")]
    [TestCase("Andrew Jackson")]
    [TestCase("村上春樹", TestName="{m}(HarukiMurakami)")]
    [TestCase("三島 由紀夫", TestName="{m}(MishimaYukio)")]
    [TestCase("吉本ばなな", TestName="{m}(YoshimotoBanana)")]
    [TestCase("大江健三郎", TestName="{m}(OeKenzaburo)")]
    [TestCase("川端 康成", TestName="{m}(KawabataYasunari)")]
    [TestCase("桐野夏生", TestName="{m}(TongyeXiasheng)")]
    [TestCase("芥川龍之介", TestName="{m}(RyunosukeAkutagawa)")]
    [TestCase("로마는 하루아침에 이루어진 것이 아니다", TestName="{m}(Korean-Proverb1)")]
    [TestCase("낮말은 새가 듣고 밤말은 쥐가 듣는다", TestName="{m}(Korean-Proverb2)")]
    [TestCase("말을 냇가에 끌고 갈 수는 있어도 억지로 물을 먹일 수는 없다", TestName="{m}(Korean-Proverb3)")]
    [TestCase("호랑이에게 물려가도 정신만 차리면 산다", TestName="{m}(Korean-Proverb4)")]
    [TestCase("Љубазни фењерџија чађавог лица хоће да ми покаже штос.", TestName = "{m}(Serbian-Pangram)")]
    [TestCase("Лако ти је плитку воду замутити и будалу наљутити", TestName = "{m}(Serbian-Proverb)")]
    [TestCase("Үнэн үг хэлсэн хүнд ноёд өстэй, үхэр унасан хүнд ноход өстэй.", TestName="{m}(Mongolian-Proverb1)")]
    [TestCase("Өнгөрсөн борооны хойноос эсгий нөмрөх.", TestName="{m}(Mongolian-Proverb2)")]
    [TestCase("Барын сүүл байснаас батганы толгой байсан нь дээр.", TestName="{m}(Mongolian-Proverb3)")]
    [TestCase("Гараар ганц хүнийг дийлэх. Tолгойгоор мянган хүнийг дийлэх.", TestName="{m}(Mongolian-Proverb4)")]
    [TestCase("Աղւէսը բերանը խաղողին չի հասնում, ասում է՝ խակ է", TestName="{m}(Armenian-Proverb1)")]
    [TestCase("Ամեն փայտ շերեփ չի դառնա, ամեն սար՝ Մասիս", TestName="{m}(Armenian-Proverb2)")]
    [TestCase("Արևին ասում է դուրս մի արի՝ ես դուրս եմ եկել", TestName="{m}(Armenian-Proverb3)")]
    [TestCase("Գայլի գլխին Աւետարան են կարդում, ասում է՝ շուտ արէ՛ք, գալլէս գնաց", TestName="{m}(Armenian-Proverb4)")]
    [TestCase("पृथिव्यां त्रीणी रत्नानि जलमन्नं सुभाषितम्।", TestName="{m}(Hindi-Proverb1)")]
    [TestCase("जननी जन्मभुमिस्छ स्वर्गादपि गरीयसि", TestName="{m}(Hindi-Proverb2)")]
    [TestCase("न अभिशेको न संस्कारः सिम्हस्य कृयते वनेविक्रमार्जितसत्वस्य स्वयमेव मृगेन्द्रता", TestName="{m}(Hindi-Proverb3)")]
    public void AddWorks(String value)
    {
        Words w = new Words();

        Assert.IsFalse(WordStorage.Instance.Contains(value));
        Assert.IsTrue(WordStorage.Instance.Entries == 1);
        w.SetString(value);
        Assert.IsTrue(WordStorage.Instance.Contains(value));
        Assert.IsTrue(WordStorage.Instance.Entries == 2);
    }

    [TestCase("red")]
    [TestCase("orange")]
    [TestCase("yellow")]
    [TestCase("green")]
    [TestCase("blue")]
    [TestCase("indigo")]
    [TestCase("violet")]
    [TestCase("紅色", TestName="{m}(Chinese-Red)")]
    [TestCase("橙色", TestName="{m}(Chinese-Orange)")]
    [TestCase("黄色", TestName="{m}(Chinese-Yellow)")]
    [TestCase("绿色", TestName="{m}(Chinese-Green)")]
    [TestCase("蓝色", TestName="{m}(Chinese-Blue")]
    [TestCase("靛蓝色", TestName="{m}(Chinese-Indigo")]
    [TestCase("紫罗兰色", TestName="{m}(Chinese-Violet")]
    [TestCase("로마는 하루아침에 이루어진 것이 아니다", TestName="{m}(Korean - Rome was not made overnight)")]
    [TestCase("낮말은 새가 듣고 밤말은 쥐가 듣는다", TestName="{m}(Korean-Proverb2)")]
    [TestCase("말을 냇가에 끌고 갈 수는 있어도 억지로 물을 먹일 수는 없다", TestName="{m}(Korean-Proverb3)")]
    [TestCase("호랑이에게 물려가도 정신만 차리면 산다", TestName="{m}(Korean-Proverb4)")]
    public void NumberedWordsWorks(String value)
    {
        NumberedWords w = new NumberedWords();
        Assert.IsTrue(WordStorage.Instance.Entries == 1);
        for (var i = 0; i < 100; ++i)
        {
            w.SetString( value + i);
            Assert.IsTrue(WordStorage.Instance.Entries == 2);
        }
    }

    [TestCase("red001")]
    [TestCase("orange2")]
    [TestCase("yellow001234")]
    [TestCase("green")]
    [TestCase("紅色002", TestName="{m}(Chinese-Red)")]
    [TestCase("橙色0035", TestName="{m}(Chinese-Orange)")]
    [TestCase("黄色000234", TestName="{m}(Chinese-Yellow)")]
    [TestCase("绿色00003423", TestName="{m}(Chinese-Green)")]
    public void WordStorageFixedString32Works(String value)
    {
        NumberedWords w = new NumberedWords();
        FixedString32Bytes fixedString = default;
        w.SetString(value);
        w.ToFixedString(ref fixedString);
        Assert.AreEqual(value, fixedString.ToString());
    }

    [TestCase("red001")]
    [TestCase("orange2")]
    [TestCase("yellow001234")]
    [TestCase("green")]
    [TestCase("紅色002", TestName="{m}(Chinese-Red)")]
    [TestCase("橙色0035", TestName="{m}(Chinese-Orange)")]
    [TestCase("黄色000234", TestName="{m}(Chinese-Yellow)")]
    [TestCase("绿色00003423", TestName="{m}(Chinese-Green)")]
    public void WordStorageFixedString64Works(String value)
    {
        NumberedWords w = new NumberedWords();
        FixedString64Bytes fixedString = default;
        w.SetString(value);
        w.ToFixedString(ref fixedString);
        Assert.AreEqual(value, fixedString.ToString());
    }

    [TestCase("red001")]
    [TestCase("orange2")]
    [TestCase("yellow001234")]
    [TestCase("green")]
    [TestCase("紅色002", TestName="{m}(Chinese-Red)")]
    [TestCase("橙色0035", TestName="{m}(Chinese-Orange)")]
    [TestCase("黄色000234", TestName="{m}(Chinese-Yellow)")]
    [TestCase("绿色00003423", TestName="{m}(Chinese-Green)")]
    public void WordStorageFixedString128Works(String value)
    {
        NumberedWords w = new NumberedWords();
        FixedString128Bytes fixedString = default;
        w.SetString(value);
        w.ToFixedString(ref fixedString);
        Assert.AreEqual(value, fixedString.ToString());
    }

}

}
#pragma warning restore 0618
#endif
